/** @file   StarGate.h
 * @brief   Declaration of StarGate class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/07/27 20:29:40 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_STARGATE_H
#define H_WWW_STARGATE_H

#include "GameObject.h"

namespace WeWantWar {

/** @class  StarGate
 * @brief   A class for the stargate that must be destroyed in city level.
 * @author  Tomi Lamminsaari
 *
 */
class StarGate : public GameObject
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================
  
  static const int KDyingCounterIndex = 2;
  static const int KSpawnCounterIndex = 1;

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   */
  StarGate();

  /** Destructor
   */
  virtual ~StarGate();

private:
  StarGate( const StarGate& aAnother );
  StarGate& operator= ( const StarGate& aAnother );
public:

  ///
  /// Inherited methods
  /// =================

  /** From GameObject
   */
  virtual void update();
  
  /** From GameObject
   */
  virtual void redraw( RedrawQueue* aQueue );
  
  /** From GameObject
   */
  virtual bool hitByBullet( Bullet* aBullet );
  
  /** From GameObject
   */
  virtual void makeSound( GameObject::SoundID aSoundId ) const;
  
  /** From GameObject
   */
  virtual void kill();
  
  /** From GameObject
   */
  virtual ObjectID::Type objectType() const;
  
  /** From GameObject
   */
  virtual bool reloading() const;
  

  ///
  /// New public methods
  /// ==================

  /** Sets the delay how often this stargate creates new aliens.
   * @param   aDelay            Delay. -1 turns spawn feature off.
   */
  void setSpawnDelay( int aDelay );

  ///
  /// Getter methods
  /// ==============


protected:
  ///
  /// Protected interface
  /// ===================
  
  std::string randomizeAlienType() const;


protected:
  ///
  /// Data members
  /// ============

  int iSpawnDelay;
};

};  // end of namespace

#endif
